const express = require('express');
const router = express.Router();
const { authenticateSuperAdmin } = require('../middleware/auth');
const {
    getAllHotels,
    createHotel,
    updateHotelSubscription,
    toggleHotelStatus,
    deleteHotel
} = require('../controllers/superAdminController');

// All routes require super admin authentication
router.use(authenticateSuperAdmin);

// Get all hotels
router.get('/hotels', getAllHotels);

// Create new hotel
router.post('/hotels', createHotel);

// Update hotel subscription
router.put('/hotels/:id/subscription', updateHotelSubscription);

// Toggle hotel active status
router.put('/hotels/:id/status', toggleHotelStatus);

// Delete hotel
router.delete('/hotels/:id', deleteHotel);

module.exports = router;
