const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/database');
const Hotel = require('./Hotel');

const Offer = sequelize.define('Offer', {
    id: {
        type: DataTypes.STRING(36),
        primaryKey: true,
        defaultValue: DataTypes.UUIDV4
    },
    hotelId: {
        type: DataTypes.STRING(36),
        allowNull: false,
        field: 'hotel_id',
        references: {
            model: Hotel,
            key: 'id'
        },
        onDelete: 'CASCADE'
    },
    name: {
        type: DataTypes.STRING(255),
        allowNull: false
    },
    description: {
        type: DataTypes.TEXT
    },
    discountType: {
        type: DataTypes.ENUM('Percentage', 'Fixed', 'Combo'),
        allowNull: false,
        field: 'discount_type'
    },
    discountValue: {
        type: DataTypes.DECIMAL(10, 2),
        allowNull: false,
        field: 'discount_value'
    },
    startDate: {
        type: DataTypes.DATE,
        allowNull: false,
        field: 'start_date'
    },
    endDate: {
        type: DataTypes.DATE,
        allowNull: false,
        field: 'end_date'
    },
    targetMealTime: {
        type: DataTypes.ENUM('Breakfast', 'Lunch', 'Dinner'),
        field: 'target_meal_time'
    },
    targetCategory: {
        type: DataTypes.STRING(100),
        field: 'target_category'
    }
}, {
    tableName: 'offers',
    timestamps: true
});

// Define association
Offer.belongsTo(Hotel, { foreignKey: 'hotelId', as: 'hotel' });
Hotel.hasMany(Offer, { foreignKey: 'hotelId', as: 'offers' });

module.exports = Offer;
