const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/database');
const Hotel = require('./Hotel');
const Category = require('./Category');

const MenuItem = sequelize.define('MenuItem', {
    id: {
        type: DataTypes.STRING(36),
        primaryKey: true,
        defaultValue: DataTypes.UUIDV4
    },
    hotelId: {
        type: DataTypes.STRING(36),
        allowNull: false,
        field: 'hotel_id',
        references: {
            model: Hotel,
            key: 'id'
        },
        onDelete: 'CASCADE'
    },
    categoryId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'category_id',
        references: {
            model: Category,
            key: 'id'
        },
        onDelete: 'CASCADE'
    },
    name: {
        type: DataTypes.STRING(255),
        allowNull: false
    },
    description: {
        type: DataTypes.TEXT
    },
    price: {
        type: DataTypes.DECIMAL(10, 2),
        allowNull: false
    },
    offerPrice: {
        type: DataTypes.DECIMAL(10, 2),
        field: 'offer_price'
    },
    imageUrl: {
        type: DataTypes.STRING(500),
        field: 'image_url'
    },
    mealTime: {
        type: DataTypes.ENUM('Breakfast', 'Lunch', 'Dinner'),
        allowNull: false,
        field: 'meal_time'
    },
    dietaryType: {
        type: DataTypes.ENUM('Veg', 'Non-Veg', 'Vegan', 'None'),
        defaultValue: 'None',
        field: 'dietary_type'
    },
    isSpecial: {
        type: DataTypes.BOOLEAN,
        defaultValue: false,
        field: 'is_special'
    },
    isVisible: {
        type: DataTypes.BOOLEAN,
        defaultValue: true,
        field: 'is_visible'
    },
    availableFrom: {
        type: DataTypes.TIME,
        field: 'available_from'
    },
    availableTo: {
        type: DataTypes.TIME,
        field: 'available_to'
    }
}, {
    tableName: 'menu_items',
    timestamps: true
});

// Define associations
MenuItem.belongsTo(Hotel, { foreignKey: 'hotelId', as: 'hotel' });
MenuItem.belongsTo(Category, { foreignKey: 'categoryId', as: 'category' });
Hotel.hasMany(MenuItem, { foreignKey: 'hotelId', as: 'menuItems' });
Category.hasMany(MenuItem, { foreignKey: 'categoryId', as: 'items' });

module.exports = MenuItem;
