const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/database');

const Hotel = sequelize.define('Hotel', {
    id: {
        type: DataTypes.STRING(36),
        primaryKey: true,
        defaultValue: DataTypes.UUIDV4
    },
    name: {
        type: DataTypes.STRING(255),
        allowNull: false
    },
    email: {
        type: DataTypes.STRING(255),
        allowNull: false,
        unique: true,
        validate: {
            isEmail: true
        }
    },
    passwordHash: {
        type: DataTypes.STRING(255),
        allowNull: false,
        field: 'password_hash'
    },
    subscriptionEnd: {
        type: DataTypes.DATE,
        allowNull: false,
        field: 'subscription_end'
    },
    isActive: {
        type: DataTypes.BOOLEAN,
        defaultValue: true,
        field: 'is_active'
    },
    logoUrl: {
        type: DataTypes.STRING(500),
        field: 'logo_url',
        defaultValue: 'https://via.placeholder.com/100'
    },
    bannerUrl: {
        type: DataTypes.STRING(500),
        field: 'banner_url',
        defaultValue: 'https://via.placeholder.com/1200x400'
    },
    whatsappNumber: {
        type: DataTypes.STRING(20),
        field: 'whatsapp_number'
    },
    phone: {
        type: DataTypes.STRING(20)
    },
    address: {
        type: DataTypes.TEXT
    },
    tagline: {
        type: DataTypes.STRING(255)
    },
    description: {
        type: DataTypes.TEXT
    }
}, {
    tableName: 'hotels',
    timestamps: true
});

module.exports = Hotel;
