-- ============================================
-- Sample Data for Testing
-- Hotel Ordering System
-- ============================================
-- Run this AFTER running schema.sql and initDatabase.js
-- This provides additional test data for development
-- ============================================

USE hotel_ordering_db;

-- Note: The initDatabase.js script already creates:
-- 1. Super Admin (superadmin@hotel.com)
-- 2. Demo Hotel (demo@hotel.com)
-- 3. Default categories for demo hotel

-- ============================================
-- Add Sample Menu Items for Demo Hotel
-- ============================================
-- Replace 'DEMO_HOTEL_ID' with actual ID from initDatabase output
-- Replace category IDs with actual IDs from your database

-- Example: Get hotel ID and category IDs
-- SELECT id FROM hotels WHERE email = 'demo@hotel.com';
-- SELECT id, name FROM categories WHERE hotel_id = 'YOUR_HOTEL_ID';

-- Sample Starters (category_id = 1)
INSERT INTO menu_items (id, hotel_id, category_id, name, description, price, meal_time, dietary_type, is_special, is_visible)
VALUES 
(UUID(), 'YOUR_HOTEL_ID', 1, 'Spring Rolls', 'Crispy vegetable spring rolls served with sweet chili sauce', 8.99, 'Lunch', 'Veg', FALSE, TRUE),
(UUID(), 'YOUR_HOTEL_ID', 1, 'Chicken Wings', 'Spicy buffalo wings with ranch dressing', 12.99, 'Dinner', 'Non-Veg', TRUE, TRUE),
(UUID(), 'YOUR_HOTEL_ID', 1, 'Garlic Bread', 'Toasted bread with garlic butter and herbs', 5.99, 'Lunch', 'Veg', FALSE, TRUE);

-- Sample Main Course (category_id = 2)
INSERT INTO menu_items (id, hotel_id, category_id, name, description, price, offer_price, meal_time, dietary_type, is_special, is_visible)
VALUES 
(UUID(), 'YOUR_HOTEL_ID', 2, 'Margherita Pizza', 'Classic pizza with fresh mozzarella and basil', 14.99, 12.99, 'Lunch', 'Veg', FALSE, TRUE),
(UUID(), 'YOUR_HOTEL_ID', 2, 'Grilled Chicken', 'Herb-marinated grilled chicken with vegetables', 18.99, NULL, 'Dinner', 'Non-Veg', TRUE, TRUE),
(UUID(), 'YOUR_HOTEL_ID', 2, 'Pasta Alfredo', 'Creamy fettuccine alfredo with parmesan', 15.99, NULL, 'Lunch', 'Veg', FALSE, TRUE);

-- Sample Beverages (category_id = 3)
INSERT INTO menu_items (id, hotel_id, category_id, name, description, price, meal_time, dietary_type, is_visible)
VALUES 
(UUID(), 'YOUR_HOTEL_ID', 3, 'Fresh Orange Juice', 'Freshly squeezed orange juice', 4.99, 'Breakfast', 'Vegan', TRUE),
(UUID(), 'YOUR_HOTEL_ID', 3, 'Cappuccino', 'Italian style cappuccino', 3.99, 'Breakfast', 'Veg', TRUE),
(UUID(), 'YOUR_HOTEL_ID', 3, 'Iced Tea', 'Refreshing lemon iced tea', 2.99, 'Lunch', 'Vegan', TRUE);

-- Sample Desserts (category_id = 4)
INSERT INTO menu_items (id, hotel_id, category_id, name, description, price, meal_time, dietary_type, is_special, is_visible)
VALUES 
(UUID(), 'YOUR_HOTEL_ID', 4, 'Chocolate Cake', 'Rich chocolate cake with ganache', 6.99, 'Dinner', 'Veg', TRUE, TRUE),
(UUID(), 'YOUR_HOTEL_ID', 4, 'Ice Cream Sundae', 'Vanilla ice cream with toppings', 5.99, 'Lunch', 'Veg', FALSE, TRUE),
(UUID(), 'YOUR_HOTEL_ID', 4, 'Tiramisu', 'Classic Italian tiramisu', 7.99, 'Dinner', 'Veg', TRUE, TRUE);

-- ============================================
-- Add Sample Offers
-- ============================================
INSERT INTO offers (id, hotel_id, name, description, discount_type, discount_value, start_date, end_date, target_meal_time)
VALUES 
(UUID(), 'YOUR_HOTEL_ID', 'Lunch Special', 'Get 20% off on all lunch items', 'Percentage', 20.00, NOW(), DATE_ADD(NOW(), INTERVAL 30 DAY), 'Lunch'),
(UUID(), 'YOUR_HOTEL_ID', 'Weekend Dinner Deal', 'Flat $5 off on dinner orders above $30', 'Fixed', 5.00, NOW(), DATE_ADD(NOW(), INTERVAL 7 DAY), 'Dinner');

-- ============================================
-- Create Additional Test Hotel
-- ============================================
-- Password: test123 (will need to be hashed with bcrypt)
-- Use the Super Admin panel or API to create additional hotels

-- ============================================
-- Verification Queries
-- ============================================

-- Check all menu items
-- SELECT m.name, m.price, c.name as category, m.meal_time, m.dietary_type
-- FROM menu_items m
-- JOIN categories c ON m.category_id = c.id
-- WHERE m.hotel_id = 'YOUR_HOTEL_ID';

-- Check all offers
-- SELECT name, discount_type, discount_value, start_date, end_date
-- FROM offers
-- WHERE hotel_id = 'YOUR_HOTEL_ID';

-- ============================================
-- End of Sample Data
-- ============================================
